require "class"
local Badge = require "widgets/badge"
local easing = require "easing"
local brain = require "brains/summonclonebrain"
local brain_boat = require "brains/summonclonebrain_boat"
local function OnSane(inst)
	print ("SANE!")
end

local function OnInsane(inst)
---	inst.SoundEmitter:PlaySound("dontstarve/sanity/gonecrazy_stinger")
end

--[[
local _assets =
{
    dont_starve =
    {
        Asset("ANIM", "anim/player_basic.zip"),
        Asset("ANIM", "anim/player_idles_shiver.zip"),
        Asset("ANIM", "anim/player_actions.zip"),
        Asset("ANIM", "anim/player_actions_axe.zip"),
        Asset("ANIM", "anim/player_actions_pickaxe.zip"),
        Asset("ANIM", "anim/player_actions_shovel.zip"),
        Asset("ANIM", "anim/player_actions_blowdart.zip"),
        Asset("ANIM", "anim/player_actions_eat.zip"),
        Asset("ANIM", "anim/player_actions_item.zip"),
        Asset("ANIM", "anim/player_cave_enter.zip"),
        Asset("ANIM", "anim/player_actions_uniqueitem.zip"),
        Asset("ANIM", "anim/player_actions_bugnet.zip"),
        Asset("ANIM", "anim/player_actions_fishing.zip"),
        Asset("ANIM", "anim/player_actions_boomerang.zip"),
        Asset("ANIM", "anim/player_bush_hat.zip"),
        Asset("ANIM", "anim/player_attacks.zip"),
        Asset("ANIM", "anim/player_idles.zip"),
        Asset("ANIM", "anim/player_rebirth.zip"),
        Asset("ANIM", "anim/player_jump.zip"),
        Asset("ANIM", "anim/player_amulet_resurrect.zip"),
		Asset("ANIM", "anim/player_teleport.zip"),
        Asset("ANIM", "anim/wilson_fx.zip"),
        Asset("ANIM", "anim/player_one_man_band.zip"),
        Asset("ANIM", "anim/player_slurtle_armor.zip"),
        Asset("ANIM", "anim/player_staff.zip"),

		Asset("ANIM", "anim/shadow_hands.zip"),

        Asset("SOUND", "sound/sfx.fsb"),
        Asset("SOUND", "sound/wilson.fsb"),

        Asset("ANIM", "anim/fish01.zip"),   --These are used for the fishing animations.
        Asset("ANIM", "anim/eel01.zip"),
		
		
		Asset("ANIM", "anim/shadow_hands.zip"),

        Asset("SOUND", "sound/sfx.fsb"),
        Asset("SOUND", "sound/wilson.fsb"),
		Asset("ANIM", "anim/willow.zip"),
		Asset("SOUND", "sound/willow.fsb"),
		Asset("ANIM", "anim/wes.zip"),
		Asset("ANIM", "anim/wolfgang.zip"),
		Asset("SOUND", "sound/wolfgang.fsb"),
		Asset("ANIM", "anim/wendy.zip"),
		Asset("SOUND", "sound/wendy.fsb"),
		Asset("ANIM", "anim/wx78.zip"),
		Asset("SOUND", "sound/wx78.fsb"),
		Asset("SOUND", "sound/maxwell.fsb"),
		Asset("ANIM", "anim/waxwell.zip"),
		Asset("SOUND", "sound/wickerbottom.fsb"),
		Asset("ANIM", "anim/wickerbottom.zip"),
		Asset("SOUND", "sound/woodie.fsb"),
		Asset("ANIM", "anim/woodie.zip"),
    },
	
	
    shipwrecked =
    {
		Asset("ANIM", "anim/player_basic.zip"),
		Asset("ANIM", "anim/player_idles_shiver.zip"),
		Asset("ANIM", "anim/player_actions.zip"),
		Asset("ANIM", "anim/player_actions_axe.zip"),
		Asset("ANIM", "anim/player_actions_pickaxe.zip"),
		Asset("ANIM", "anim/player_actions_shovel.zip"),
		Asset("ANIM", "anim/player_actions_blowdart.zip"),
	--	Asset("ANIM", "anim/player_actions_speargun.zip"),//
		--Asset("ANIM", "anim/player_actions_machete.zip"), --This file overwrites the axe actions file and is broken...
		Asset("ANIM", "anim/player_actions_eat.zip"),
		Asset("ANIM", "anim/player_actions_item.zip"),
		Asset("ANIM", "anim/player_actions_paddle.zip"),
		Asset("ANIM", "anim/player_cave_enter.zip"),
		Asset("ANIM", "anim/player_actions_uniqueitem.zip"),
		Asset("ANIM", "anim/book_uniqueitem_swap.zip"),
		Asset("ANIM", "anim/player_actions_bugnet.zip"),
		Asset("ANIM", "anim/player_actions_fishing.zip"),
		Asset("ANIM", "anim/player_actions_boomerang.zip"),
		Asset("ANIM", "anim/player_bush_hat.zip"),
		Asset("ANIM", "anim/player_attacks.zip"),
		Asset("ANIM", "anim/player_idles.zip"),
		Asset("ANIM", "anim/player_rebirth.zip"),
		Asset("ANIM", "anim/player_jump.zip"),
		Asset("ANIM", "anim/player_amulet_resurrect.zip"),
		Asset("ANIM", "anim/player_teleport.zip"),
		Asset("ANIM", "anim/wilson_fx.zip"),
		Asset("ANIM", "anim/player_one_man_band.zip"),
		Asset("ANIM", "anim/player_slurtle_armor.zip"),
		Asset("ANIM", "anim/player_staff.zip"),
		Asset("ANIM", "anim/player_boat_onoff.zip"),
		Asset("ANIM", "anim/player_boat_death.zip"),
		Asset("ANIM", "anim/player_actions_trawl.zip"),

		Asset("ANIM", "anim/player_actions_telescope.zip"),
		Asset("ANIM", "anim/player_idles_poison.zip"),


		Asset("ANIM", "anim/player_frozen.zip"),
		Asset("ANIM", "anim/player_shock.zip"),
		Asset("ANIM", "anim/shock_fx.zip"),
		Asset("ANIM", "anim/player_tornado.zip"),


		Asset("ANIM", "anim/shadow_hands.zip"),

        Asset("SOUND", "sound/sfx.fsb"),
        Asset("SOUND", "sound/wilson.fsb"),
		Asset("ANIM", "anim/willow.zip"),
		Asset("SOUND", "sound/willow.fsb"),
		Asset("ANIM", "anim/wes.zip"),
		Asset("ANIM", "anim/wolfgang.zip"),
		Asset("SOUND", "sound/wolfgang.fsb"),
		Asset("ANIM", "anim/wendy.zip"),
		Asset("SOUND", "sound/wendy.fsb"),
		Asset("ANIM", "anim/wx78.zip"),
		Asset("SOUND", "sound/wx78.fsb"),
		Asset("SOUND", "sound/maxwell.fsb"),
		Asset("ANIM", "anim/waxwell.zip"),
		Asset("SOUND", "sound/wickerbottom.fsb"),
		Asset("ANIM", "anim/wickerbottom.zip"),
		Asset("SOUND", "sound/woodie.fsb"),
		Asset("ANIM", "anim/woodie.zip"),
	
	},
   
    reign_of_giants =
    {
        Asset("ANIM", "anim/player_basic.zip"),
        Asset("ANIM", "anim/player_idles_shiver.zip"),
        Asset("ANIM", "anim/player_actions.zip"),
        Asset("ANIM", "anim/player_actions_axe.zip"),
        Asset("ANIM", "anim/player_actions_pickaxe.zip"),
        Asset("ANIM", "anim/player_actions_shovel.zip"),
        Asset("ANIM", "anim/player_actions_blowdart.zip"),
        Asset("ANIM", "anim/player_actions_eat.zip"),
        Asset("ANIM", "anim/player_actions_item.zip"),
        Asset("ANIM", "anim/player_cave_enter.zip"),
        Asset("ANIM", "anim/player_actions_uniqueitem.zip"),
        Asset("ANIM", "anim/player_actions_bugnet.zip"),
        Asset("ANIM", "anim/player_actions_fishing.zip"),
        Asset("ANIM", "anim/player_actions_boomerang.zip"),
        Asset("ANIM", "anim/player_bush_hat.zip"),
        Asset("ANIM", "anim/player_attacks.zip"),
        Asset("ANIM", "anim/player_idles.zip"),
        Asset("ANIM", "anim/player_rebirth.zip"),
        Asset("ANIM", "anim/player_jump.zip"),
        Asset("ANIM", "anim/player_amulet_resurrect.zip"),
		Asset("ANIM", "anim/player_teleport.zip"),
        Asset("ANIM", "anim/wilson_fx.zip"),
        Asset("ANIM", "anim/player_one_man_band.zip"),
        Asset("ANIM", "anim/player_slurtle_armor.zip"),
        Asset("ANIM", "anim/player_staff.zip"),        

		Asset("ANIM", "anim/shadow_hands.zip"),

        Asset("SOUND", "sound/sfx.fsb"),
        Asset("SOUND", "sound/wilson.fsb"),
		Asset("ANIM", "anim/willow.zip"),
		Asset("SOUND", "sound/willow.fsb"),
		Asset("ANIM", "anim/wes.zip"),
		Asset("ANIM", "anim/wolfgang.zip"),
		Asset("SOUND", "sound/wolfgang.fsb"),
		Asset("ANIM", "anim/wendy.zip"),
		Asset("SOUND", "sound/wendy.fsb"),
		Asset("ANIM", "anim/wx78.zip"),
		Asset("SOUND", "sound/wx78.fsb"),
		Asset("SOUND", "sound/maxwell.fsb"),
		Asset("ANIM", "anim/waxwell.zip"),
		Asset("SOUND", "sound/wickerbottom.fsb"),
		Asset("ANIM", "anim/wickerbottom.zip"),
		Asset("SOUND", "sound/woodie.fsb"),
		Asset("ANIM", "anim/woodie.zip"),

	},
   

}
 
--local assets = {}
 
--]]


local assets = {
		Asset("ANIM", "anim/player_basic.zip"),
		Asset("ANIM", "anim/player_idles_shiver.zip"),
		Asset("ANIM", "anim/player_actions.zip"),
		Asset("ANIM", "anim/player_actions_axe.zip"),
		Asset("ANIM", "anim/player_actions_pickaxe.zip"),
		Asset("ANIM", "anim/player_actions_shovel.zip"),
	--	Asset("ANIM", "anim/player_actions_blowdart.zip"),
	--	Asset("ANIM", "anim/player_actions_speargun.zip"),
		--Asset("ANIM", "anim/player_actions_machete.zip"), --This file overwrites the axe actions file and is broken...
		Asset("ANIM", "anim/player_actions_eat.zip"),
		Asset("ANIM", "anim/player_actions_item.zip"),
		Asset("ANIM", "anim/player_actions_paddle.zip"),
		Asset("ANIM", "anim/player_cave_enter.zip"),
		Asset("ANIM", "anim/player_actions_uniqueitem.zip"),
		Asset("ANIM", "anim/book_uniqueitem_swap.zip"),
		Asset("ANIM", "anim/player_actions_bugnet.zip"),
		Asset("ANIM", "anim/player_actions_fishing.zip"),
		Asset("ANIM", "anim/player_actions_boomerang.zip"),
		Asset("ANIM", "anim/player_bush_hat.zip"),
		Asset("ANIM", "anim/player_attacks.zip"),
		Asset("ANIM", "anim/player_idles.zip"),
		Asset("ANIM", "anim/player_rebirth.zip"),
		Asset("ANIM", "anim/player_jump.zip"),
		Asset("ANIM", "anim/player_amulet_resurrect.zip"),
		Asset("ANIM", "anim/player_teleport.zip"),
		Asset("ANIM", "anim/wilson_fx.zip"),
		Asset("ANIM", "anim/player_one_man_band.zip"),
		Asset("ANIM", "anim/player_slurtle_armor.zip"),
		Asset("ANIM", "anim/player_staff.zip"),
		Asset("ANIM", "anim/player_boat_onoff.zip"),
		Asset("ANIM", "anim/player_boat_death.zip"),
		Asset("ANIM", "anim/player_actions_trawl.zip"),

		--Asset("ANIM", "anim/player_actions_telescope.zip"),
		Asset("ANIM", "anim/player_idles_poison.zip"),


		Asset("ANIM", "anim/player_frozen.zip"),
		Asset("ANIM", "anim/player_shock.zip"),
		Asset("ANIM", "anim/shock_fx.zip"),
		Asset("ANIM", "anim/player_tornado.zip"),


		Asset("ANIM", "anim/shadow_hands.zip"),

        Asset("SOUND", "sound/sfx.fsb"),
        Asset("SOUND", "sound/wilson.fsb"),
		Asset("ANIM", "anim/willow.zip"),
		Asset("SOUND", "sound/willow.fsb"),
		Asset("ANIM", "anim/wes.zip"),
		Asset("ANIM", "anim/player_mime.zip"),    
		Asset("ANIM", "anim/wolfgang.zip"),
		Asset("SOUND", "sound/wolfgang.fsb"),
		Asset("ANIM", "anim/wendy.zip"),
		Asset("SOUND", "sound/wendy.fsb"),
		Asset("ANIM", "anim/wx78.zip"),
		Asset("SOUND", "sound/wx78.fsb"),
		Asset("SOUND", "sound/maxwell.fsb"),
		Asset("ANIM", "anim/waxwell.zip"),
		Asset("SOUND", "sound/wickerbottom.fsb"),
		Asset("ANIM", "anim/wickerbottom.zip"),
		Asset("SOUND", "sound/woodie.fsb"),
		Asset("ANIM", "anim/woodie.zip"),
	
}



	
	
	
	
local prefabs =
{
"abigail_3","lucy","lighter"
}

local onloadfn = function(inst, data)
	if data and data.sleeping then
		inst.components.sleeper:GoToSleep()
	end
end

local onsavefn = function(inst, data)
	if inst.components.sleeper:IsAsleep() then
		data.sleeping = true
	end
end

local function CalcSanityAura(inst, observer)
	
	if inst.components.follower and inst.components.follower.leader == observer then
		return -TUNING.SANITYAURA_LARGE
	end
	
	return 0
end


local function ontalk(inst, script)
	if not inst:HasTag("p3talkcd") then
	inst:AddTag("p3talkcd")
	inst.SoundEmitter:PlaySound("dontstarve/characters/"..inst.typeoftalks.."/talk_LP","p3talksound")
	print("dark clone sound")
	inst:DoTaskInTime(1.8, function()
	inst.SoundEmitter:KillSound("p3talksound")
	
    inst:RemoveTag("p3talkcd")
    end)
	end
end



local function oneatwx78(inst, food)
	
	if food and food.components.edible and math.random()<0.05 then
		inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")

		
		--inst.components.hunger:DoDelta(225)
		--inst.components.sanity:DoDelta(225)
	--	inst.components.health:DoDelta(225)	
		local goldnugget = SpawnPrefab("goldnugget")
		local pt = inst:GetPosition()
		goldnugget.Transform:SetPosition(pt.x, pt.y, pt.z)
	end
end



local function CalcSanityAura_Maxwell(inst, observer)
	return 0
end

local function ShouldAcceptItem(inst, item)
        	return true
end

local function OnGetItemFromPlayer(inst, giver, item)
  --  	inst.components.container:GiveItem(item)
  
			inst.components.inventory:DropItem(item, true)		
--			inst.components.inventory:RemoveItemBySlot(num)	
---			inst.components.container:RemoveItemBySlot(num)		
end

local function OnRefuseItem(inst, item)

end

local function NormalRetargetFn(inst)
    return FindEntity(inst, TUNING.PIG_TARGET_DIST,
        function(guy)
                return guy:HasTag("monster") and guy.components.health and not guy.components.health:IsDead() and inst.components.combat:CanTarget(guy)
        end)
end


local function OnOpen(inst)
end 

local function OnClose(inst) 
end 

local slotpos = {}


	for y = 0, 4 do		--5 rows, 3 cols
		--							 ([hor] [loc], [hor width between rows] + [ver] ,0))	
		table.insert(slotpos, Vector3(-25 -150, -y*75 + 185 ,0)) --New column
		table.insert(slotpos, Vector3(-25  -75, -y*75 + 185 ,0)) --original column
		table.insert(slotpos, Vector3(-25     , -y*75 + 185 ,0)) --col at screen edge
	end


local function OnAttackedWendy(inst, data)
    inst:DoTaskInTime(0, function() 
    		local found = false
    		for k,v in pairs(Ents) do
    			if v.prefab == "abigail_3" then
    				found = true
    				break
    			end
    		end
    		if not found then
    local attacker = data.attacker
    local abigail_3 = SpawnPrefab("abigail_3")
    abigail_3.Transform:SetPosition(inst.Transform:GetWorldPosition())
    abigail_3.components.combat:SetTarget(attacker)
    		end
    	end)
end
---OnWendyAttack

local function OnWendyAttack(inst, other)
    inst:DoTaskInTime(0, function() 
    		local found = false
    		for k,v in pairs(Ents) do
    			if v.prefab == "abigail_3" then
    				found = true
    				break
    			end
    		end
    		if not found then
    local target = other
    local abigail_3 = SpawnPrefab("abigail_3")
    abigail_3.Transform:SetPosition(inst.Transform:GetWorldPosition())
    abigail_3.components.combat:SetTarget(other)
    		end
    	end)
end



local function OnItemGet(data)
	if inst.collectedParts[item.prefab] ~= nil then
		inst.collectedParts[item.prefab] = true
		inst.SoundEmitter:PlaySound("dontstarve/common/teleportato/teleportato_addpart", "teleportato_addpart")
		TestForPowerUp(inst)
	end
end




local function DropLastItem(inst,data)
---broken
--if 1==1 then return end
local last = data.item
--print("drop last item")
if inst.components.inventory:IsFull() then
		inst:AddTag("no_actions_full_inv")


--	local item = last
	local item = inst.components.inventory:GetItemInSlot(16)
--	print("item last="..item.prefab)
	
	inst.components.talker:Say("I can not carry any more!")
	
	
	inst:DoTaskInTime(0.5, function() 
		inst.components.inventory:DropItem(item, true)	
		--inst.components.container:DropItem(item, true)	
		inst.components.inventory:RemoveItem(item,true)	
	--	inst.components.container:RemoveItem(item,true)	
		inst:RemoveTag("no_actions_full_inv")
    end)	
	
	
	
end
end

local function OnAttackedWaxwell(inst, data)
    local attacker = data.attacker
	local dmg = data.damage
	if not inst:HasTag("cdlf") and attacker.components.health.currenthealth > 1 then
	attacker.components.health:DoDelta(-dmg)
	inst.components.health:DoDelta(dmg)
	print("lifeSteal")
	
	inst:AddTag("cdlf")
	inst:DoTaskInTime(0.7, function() 
    inst:RemoveTag("cdlf")
    end)

end
end



local function makeactive(inst)
	inst.components.activatable.inactive = nil
end




local function makeused(inst)
	inst.components.activatable.inactive = nil
end

local function doresurrect(inst, dude)
	dude.components.p3stats_saver:RespawnDelta(-1,dude)
	
	--[[local canrespawn = 	dude.components.p3stats_saver:CanRespawn()
	if canrespawn == false then
		print("I am dying just to let you live...")
	end--]]
	
	inst.components.health:SetPercent(.35)
	inst.components.sanity:DoDelta(-25)
	inst.components.hunger:DoDelta(-25)

    dude.Transform:SetPosition(inst.Transform:GetWorldPosition())
    dude:Hide()
    TheCamera:SetDistance(12)
	dude.components.hunger:Pause()
	
    scheduler:ExecuteInTime(3, function()
        dude:Show()
        
        if dude.components.hunger then
            dude.components.hunger:SetPercent(2/3)
        end

        if dude.components.health then
            dude.components.health:Respawn(TUNING.RESURRECT_HEALTH)
        end
        
        if dude.components.sanity then
			dude.components.sanity:SetPercent(.5)
        end
        
        dude.components.hunger:Resume()
        
        dude.sg:GoToState("wakeup")
        
		dude.HUD:Show()
        
    end)
	
	if dude.components.p3stats_saver.stat["respawnsleft"]<1 then
		inst.components.health:Kill()
	
	end
end

local function DropItem(inst, target, item)
	inst.components.inventory:Unequip(EQUIPSLOTS.HANDS, true)
	inst.components.inventory:DropItem(item)
	if item.Physics then

		local x, y, z = item:GetPosition():Get()
		y = .3
		item.Physics:Teleport(x,y,z)

		local hp = target:GetPosition()
		local pt = inst:GetPosition()
		local vel = (hp - pt):GetNormalized()
		local speed = 3 + (math.random() * 2)
		local angle = -math.atan2(vel.z, vel.x) + (math.random() * 20 - 10) * DEGREES
		item.Physics:SetVel(math.cos(angle) * speed, 10, math.sin(angle) * speed)
		inst.components.talker:Say("Damn it!")
	end
end

local function OnWork(inst, data)
	--Tool slip.
	local m = inst.components.moisture

	if m:GetSegs() < 4 then
		return
	end

	local mm = GetWorld().components.moisturemanager
	local tool = inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS)
	if tool and mm:IsEntityWet(tool) and math.random() < easing.inSine(m:GetMoisture(), 0, 0.15, m.moistureclamp.max)  then
		if not tool:HasTag("notslippery") then
			DropItem(inst, data.target, tool)
			--Lock out from picking up for a while?
		end
	end
end

local function onworked(inst, data)
	if inst and data.target and data.target.components.workable and data.target.components.workable.action == ACTIONS.CHOP then
		inst.components.health:DoDelta(0.33,true)
		inst.components.sanity:DoDelta(0.66,true)
		inst.components.hunger:DoDelta(0.33,true)
	end
end

function MakePlayer3(plnum)

	
local function fn(Sim)
    

	
	
	
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local sound = inst.entity:AddSoundEmitter()
	local shadow = inst.entity:AddDynamicShadow()
	local whoisplayer = GetPlayer()

	
	
	shadow:SetSize( 1.5, .75 )
    inst.Transform:SetFourFaced()
	
    MakeCharacterPhysics(inst, 30, .3)

    inst:AddTag("NOCLICK")
    inst:AddTag("summonclone")
    inst:AddTag("summonedbyplayer")
    inst:AddTag("scarytoprey")
	inst:AddTag("player3")
	inst:AddTag("character")
	
	inst:AddTag("playerfriends")

	
    anim:SetBank("wilson")
    ------------------------------------------

    inst:AddComponent("locomotor") -- locomotor must be constructed before the stategraph
    inst.components.locomotor.runspeed = 6.1
    inst.components.locomotor.walkspeed = 5.1
    
    ------------------------------------------
    ------------------------------------------

----    inst:AddComponent("sanityaura")
 -----   inst.components.sanityaura.aurafn = CalcSanityAura

    MakeMediumBurnableCharacter(inst, "pig_torso")
    ------------------
    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(TUNING.WILSON_HEALTH)
	
	
    inst:AddComponent("hunger")
    inst.components.hunger:SetMax(TUNING.WILSON_HUNGER)
    inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE)
    inst.components.hunger:SetKillRate(TUNING.WILSON_HEALTH/TUNING.STARVE_KILL_TIME)
    ------------------
    
    inst:AddComponent("combat")
    inst.components.combat:SetDefaultDamage(TUNING.UNARMED_DAMAGE*0.75)
	inst.components.combat.damagemultiplier = 0.75
    --inst.components.combat.hiteffectsymbol = "pig_torso"
    inst.components.combat:SetAttackPeriod(1.5)
	
	
    inst:AddComponent("talker")
    inst.components.talker:StopIgnoringAll()
    inst.components.talker.colour = Vector3(255/255, 160/255, 40/255)	
	inst.components.talker.ontalk = ontalk
	------------------------------------------
    
    inst:AddComponent("inventory")
	
	inst.components.inventory.maxslots = 16

	local lightwatch = inst.entity:AddLightWatcher()
    lightwatch:SetLightThresh(.2)
    lightwatch:SetDarkThresh(.05)

	

	
    inst:AddComponent("temperature")
	inst:AddComponent("eater")

	inst:AddComponent("follower")
	
		--[[local function loadassets( _assets )
			for _, asset in pairs(_assets) do
				table.insert(assets, asset)
			end
		end
		 

		if IsDLCEnabled(REIGN_OF_GIANTS) then
			loadassets(_assets.reign_of_giants)
			print("ASSETS LOADED == REIGN_OF_GIANTS")
		elseif IsDLCEnabled(CAPY_DLC) then
			loadassets(_assets.shipwrecked)
			print("ASSETS LOADED == CAPY_DLC")

		else
					print("ASSETS LOADED == BASE GAME")

			loadassets(_assets.dont_starve)
		end			--]]
				
	
	--//----------------------------------------------------------------//--
	---------------------/////////////Customising character/////////////---------------------

	anim:SetBuild("wilson")
	
	local newtagforclone = ""
	newtagforclone = whoisplayer.components.p3stats_saver.stat["char"]
	whoisplayer:AddTag(newtagforclone)
	inst:AddTag(newtagforclone)
	local name = newtagforclone
	anim:SetBuild(newtagforclone)

	print("ADDING TAG: "..newtagforclone)
	
	inst.typeoftalks = newtagforclone
	if inst.typeoftalks == "waxwell" or inst.typeoftalks == "maxwell" then inst.typeoftalks = "maxwell"	end

	


	
	
	--//----------------------------------------------------------------//--
	---------------------/////////////R o G/////////////---------------------
	if GetPlayer().components.moisture then
		print("adding moisture component")
		inst:AddComponent("moisture")
		
		
		inst:ListenForEvent("working", OnWork)
		inst:AddComponent("sanity")
		inst.components.sanity:SetMax(TUNING.WILSON_SANITY)
		inst.components.sanity.onSane = OnSane
		inst.components.sanity.onInsane = OnInsane
	end
	---------------------/////////////rog end/////////////---------------------
	--//----------------------------------------------------------------//--
	--//----------------------------------------------------------------//--
	


	--//----------------------------------------------------------------//--
	---------------------/////////////Ship Wrecked/////////////---------------------
	if GetPlayer().components.poisonable then
		MakePoisonableCharacter(inst)
		inst.components.poisonable.duration = TUNING.POISON_DURATION
		inst.components.poisonable.transfer_poison_on_attack = false
		
		
		inst.Soak = function()
			local percent = 1 - inst.components.inventory:GetWaterproofness()
			print("Soaker!! "..percent)
			inst.components.moisture:Soak(percent)
			--inst.components.inventory:Soak()
			GetWorld().components.inventorymoisture:Soak(percent)
		end
		
		inst.components.combat.hiteffectsymbol = "torso"
		
		MakeHugeFreezableCharacter(inst)
		inst.components.freezable:SetDefaultWearOffTime(TUNING.PLAYER_FREEZE_WEAR_OFF_TIME)
		
		
		inst:AddComponent("driver")
		inst.components.driver.landstategraph = "SGcloneplayer"
		inst.components.driver.boatingstategraph = "SGcloneboating_alone"
		inst.components.driver.onStartDriving = function()
			--Tell the state graph that we're about to start driving
			--inst:PushEvent("driving_start")
			--This is now handled by an event sent to the state graph
		end

		inst.components.driver.onStopDriving = function()
			--Tell the state graph that we're about to stop driving
			--inst:PushEvent("driving_stop")
			--This is now handled by an event sent to the state graph
		end
		

		---inst:AddComponent("keeponland")
		inst:AddComponent("catcher")
		
		
		
		
		if( name == "wolfgang" or name == "wickerbottom" or name == "wes" ) then
			anim:OverrideSymbol("torso_pelvis", name, "torso" ) --put the torso in pelvis slot to go behind
			anim:OverrideSymbol("torso", name, "torso_pelvis" ) --put the pelvis on top of the base torso by putting it in the torso slot
        end

		anim:PlayAnimation("idle")

		anim:Hide("ARM_carry")
		anim:Hide("hat")
		anim:Hide("hat_hair")
		anim:Hide("PROPDROP")
		anim:OverrideSymbol("fx_wipe", "wilson_fx", "fx_wipe")
		anim:OverrideSymbol("fx_liquid", "wilson_fx", "fx_liquid")
		anim:OverrideSymbol("shadow_hands", "shadow_hands", "shadow_hands")

		anim:OverrideSymbol("ripplebase", "player_boat_death", "ripplebase")
		anim:OverrideSymbol("waterline", "player_boat_death", "waterline")

	end
	---------------------/////////////end sw/////////////---------------------
	--//----------------------------------------------------------------//--
	--//----------------------------------------------------------------//--
	--//----------------------------------------------------------------//--
	
		inst:AddComponent("sanity")
		inst.components.sanity:SetMax(TUNING.WILSON_SANITY)
		inst.components.sanity.onSane = OnSane
		inst.components.sanity.onInsane = OnInsane
	
	
	--//----------------------------------------------------------------//--
	---------------------/////////////Customising stats of character/////////////---------------------


	
	if inst:HasTag("wilson") then
	    inst:AddComponent("beard")
    	inst.components.beard.onreset = function()
        	inst.AnimState:ClearOverrideSymbol("beard")
		end

		local beard_days = {1, 2, 3}
		local beard_bits = {1, 1,  1}
       		inst.components.beard:AddCallback(beard_days[1], function()
        		inst.AnimState:OverrideSymbol("beard", "beard", "beard_medium")
        		inst.components.beard.bits = beard_bits[1]
    		end)   
    		inst.components.beard:AddCallback(beard_days[2], function()
        		inst.AnimState:OverrideSymbol("beard", "beard", "beard_medium")
        		inst.components.beard.bits = beard_bits[2]
    		end) 
    		inst.components.beard:AddCallback(beard_days[3], function()
        		inst.AnimState:OverrideSymbol("beard", "beard", "beard_medium")
        		inst.components.beard.bits = beard_bits[3]
    		end)

	elseif inst:HasTag("willow") then
		inst.components.health.fire_damage_scale = 0
		inst.components.sanity:SetMax(TUNING.WILSON_SANITY*0.75)
		inst.specialitem = "lighter_player_3"
	elseif inst:HasTag("wolfgang") then
		inst.components.health:SetMaxHealth(TUNING.WILSON_HEALTH*2)
		inst.components.combat.damagemultiplier = 1.35
		inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE*1.25)
		inst.components.sanity:SetMax(TUNING.WILSON_SANITY*0.75)

	elseif inst:HasTag("wendy") then
		inst:AddTag("noauradamage")
		inst.components.combat.damagemultiplier = 0.5
		inst:ListenForEvent("attacked", OnAttackedWendy)    
		inst.components.combat.onhitotherfn = function(inst, other, damage) OnWendyAttack(inst,other) end
	elseif inst:HasTag("wx78") then
		inst.components.eater.ignoresspoilage = true
	--	table.insert(inst.components.eater.foodprefs, "GEARS")
	--	table.insert(inst.components.eater.ablefoods, "GEARS")
		inst.components.eater:SetOnEatFn(oneatwx78)
	elseif inst:HasTag("wickerbottom") then
		inst:AddComponent("reader")
		inst:AddComponent("prototyper")
		inst:AddTag("prototyper")
        inst:AddTag("level1")
		inst.components.prototyper.trees = TUNING.PROTOTYPER_TREES.SCIENCEMACHINE
		inst.components.prototyper.on = true
		inst.components.sanity:SetMax(TUNING.WILSON_SANITY*1.5)
		inst.specialitem = "bookplayer3"
	elseif inst:HasTag("waxwell") then 
		inst.components.sanity:SetMax(TUNING.WILSON_SANITY*1.1)
		inst.components.health:SetMaxHealth(TUNING.WILSON_HEALTH/2)
		inst.specialitem = "nightsword_player3"
	elseif inst:HasTag("woodie") then
		inst:ListenForEvent("working", onworked)
		inst.specialitem = "axe_player_3"
	elseif inst:HasTag("wes") then
		inst.components.talker.special_speech = true
		inst.components.combat.damagemultiplier = 0.5
		inst.components.health:SetMaxHealth(TUNING.WILSON_HEALTH * .75 )
		inst.components.hunger:SetMax(TUNING.WILSON_HUNGER * .75 )
		inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE*1.25)
		inst.components.sanity:SetMax(TUNING.WILSON_SANITY*.75)
		inst.specialitem = "balloons_empty_player_3"

	end		---------------------/////////////Customising end/////////////---------------------
	--//----------------------------------------------------------------//--

	
	

	
	
	

    inst:AddComponent("frostybreather")
    inst:AddComponent("playercontroller_3")
    inst:AddComponent("playeractionpicker_3")


	inst:AddComponent("grue")
	inst.components.grue:SetSounds("dontstarve/charlie/warn","dontstarve/charlie/attack")



    ------------------------------------------
    inst.entity:AddLabel()
    inst.Label:SetFontSize(25)
    inst.Label:SetFont(DEFAULTFONT)
    inst.Label:SetPos(0,3,0)
    inst.Label:SetColour(1, 1, 1)
    inst.Label:Enable(true)
    ------------------------------------------


    ------------------------------------------


	
	
	
	
	
    ------------------------------------------
    local minimap = inst.entity:AddMiniMapEntity()
	local newicon = newtagforclone
    minimap:SetIcon(newicon..".png")
    ------------------------------------------
   
    inst:SetBrain(brain)
    inst:AddComponent("lootdropper")

    inst:AddComponent("trader")
    inst.components.trader:SetAcceptTest(ShouldAcceptItem)
    inst.components.trader.onaccept = OnGetItemFromPlayer
    inst.components.trader.onrefuse = OnRefuseItem

    inst.AnimState:Hide("ARM_carry") 
    inst.AnimState:Show("ARM_normal") 

    inst:AddComponent("wisecrackerclone")

	--inst.components.sanity
------------//////--SANITY REBALANCE-//////--------------
    inst:DoPeriodicTask(8, function()
		if inst:HasTag("wendy") then
			inst.components.sanity:DoDelta(2,true)
		elseif inst:HasTag("waxwell") then
			inst.components.sanity:DoDelta(8,true)
		end
		
		
		if inst.components.sanity:GetPercent() > 0.9 and inst.components.sanity:GetPercent()>GetPlayer().components.sanity:GetPercent() then
		
		inst.components.sanity:DoDelta(-7,true)
		GetPlayer().components.sanity:DoDelta(8,true)
		end
		if inst.components.sanity:GetPercent() < 0.5 and inst.components.sanity:GetPercent()<GetPlayer().components.sanity:GetPercent() then
		
		inst.components.sanity:DoDelta(7,true)
		GetPlayer().components.sanity:DoDelta(-6,true)
		end
    end)
------------//////--MOISTURE REBALANCE-//////--------------

	    inst:DoPeriodicTask(4, function()
		
		if inst.components.moisture and inst.boatingwith and inst.boatingwith==1 then
			if GetPlayer().components.moisture:GetMoisturePercent()>0.25 and inst.components.moisture:GetMoisturePercent()<GetPlayer().components.moisture:GetMoisturePercent() and inst.components.moisture:GetMoisturePercent()<0.5 then
				inst.components.moisture:DoDelta(5)
				GetPlayer().components.moisture:DoDelta(-4)
			end
		end
    end)
------------//////--MOISTURE end REBALANCE-//////--------------

	
	
	
	
	
    inst:DoPeriodicTask(5, function()
		GetPlayer().components.p3stats_saver:RecordStats(inst," PERIODIC")
    end)


	
---	inst:AddComponent("dialog_des")
	inst.boatingwith = 0
	inst.mountingboat = false
	inst.startupdatingboatwithplayer = false
	
	---  inst:ListenForEvent("attacked", OnAttacked)    
	inst:AddComponent("resurrector")
	inst.components.resurrector.makeactivefn = makeactive
	inst.components.resurrector.makeusedfn = makeused
	inst.components.resurrector.doresurrect = doresurrect
	
	inst:AddComponent("activatable")
	inst.components.resurrector:OnBuilt()
	inst.components.resurrector.active = true
	
	inst.components.activatable.inactive = nil



	inst:ListenForEvent("itemget", DropLastItem)  


	local StatusDisplays = require "widgets/statusdisplays"
	local Inventorybarcloneplayer = require "widgets/Inventorybarcloneplayer"

	require "prefabs/hud"
	local doer = GetPlayer()
			

			

			
	
	if GetPlayer().components.driver then
		inst:SetStateGraph("SGcloneplayer")
	else 
		inst:SetStateGraph("SGcloneplayerROG")
	end
	
	
	
	

	
	inst:DoTaskInTime(0.25, function() 
		if doer.HUD then
			if doer.HUD.controls and doer.HUD.controls.statusplayer3 then doer.HUD.controls.statusplayer3:Kill() end
			if doer.HUD.controls and doer.HUD.controls.Inventorybarcloneplayer then doer.HUD.controls.Inventorybarcloneplayer:Kill() end
			doer.components.playercontroller_spawner:CameraPrefab()
			
			doer.HUD.controls.statusplayer3 = GetPlayer().HUD.controls.sidepanel:AddChild(StatusDisplays(inst))
			doer.HUD.controls.statusplayer3:SetPosition(-135,0,0)
			doer.HUD.controls.Inventorybarcloneplayer = GetPlayer().HUD.controls.sidepanel:AddChild(Inventorybarcloneplayer(inst))
			doer.HUD.controls.Inventorybarcloneplayer:SetPosition(-775+(TUNING.COOP_BADGE_POSITION2*TUNING.COOP_OFFEST_X),-15+(TUNING.COOP_BADGE_POSITION1*TUNING.COOP_OFFEST_Y),0)

			inst.components.follower.maxfollowtime = 99999999
			whoisplayer.components.leader:AddFollower(inst)
			inst.components.follower:AddLoyaltyTime(9999999)	
			
	--		inst.components.playercontroller_3.specialitem = inst.specialitem
			
			inst.components.playercontroller_3:GiveSpecialItems()
			
		end
	end)
		
		
		return inst
	end
		
	
    return Prefab("common/summonclone"..plnum, fn, assets, prefabs) 
end
	
return MakePlayer3(""),
MakePlayer3("2")
